package editor;

import game.IntRect;
import game.RainbowElementalSprite;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Vector;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;

public class DeleteSelectionWizard extends JPanel {
	
	private class ItemSelection {
		public int origItemIndex;
		public String name;
		public String toString() {
			return name;
		}
	}
	
	
	private JList list;
	private Vector<ItemSelection> innerList;
	
	private int[] indexesToBeErased;
	
	private JDialog parent;
	
	public int[] getIndexesToBeErased() {
		return indexesToBeErased;
	}
	
	public DeleteSelectionWizard(ArrayList<Integer> indexesForErasure, ArrayList<ScreenObject> objectsForErasure, JDialog theParent) {
		
		innerList = new Vector<DeleteSelectionWizard.ItemSelection>();
		
		parent = theParent;
		
		ItemSelection is;
		ScreenObject po;
		
		for(int i = 0; i < indexesForErasure.size() && i < objectsForErasure.size(); i++) {
			
			po = objectsForErasure.get(i);
			
			is = new ItemSelection();
			is.origItemIndex = indexesForErasure.get(i);
			
			if(po instanceof HeartScreenObject) {
				is.name = "Heart at ";
			} else if(po instanceof FlagScreenObject) {
				is.name = "Flag at ";
			} else if(po instanceof WidgetScreenObject) {
				is.name = "Widget at ";
			} else if (po instanceof RedEnemyScreenObject) {
				is.name = "Red Enemy at ";
			} else if (po instanceof BlueEnemyScreenObject) {
				is.name = "Blue Enemy at ";
			} else if (po instanceof YellowEnemyScreenObject) {
				is.name = "Yellow Enemy at ";
			} else if (po instanceof GreenEnemyScreenObject) {
				is.name = "Green Enemy at ";
			} else if (po instanceof VioletEnemyScreenObject) {
				is.name = "Violet Enemy at ";
			} else if (po instanceof GrayEnemyScreenObject) {
				is.name = "Gray Enemy at ";
			} else if(po instanceof RadioScreenObject) {
				is.name = "Radio \""+ ((RadioScreenObject)po).getCaption() +"\" at ";
			} else if(po instanceof WidgetScreenObject) {
				is.name = "Widget at ";
			} else if(po instanceof RainbowBossScreenObject) {
				is.name = "Boss at ";
			} else if(po instanceof HorizontalBlockScreenObject) {
				is.name = "Horizontally-Moving Block at ";
			} else if(po instanceof VerticalBlockScreenObject) {
				is.name = "Vertically-Moving Block at ";
			} else if(po instanceof RogueBlockScreenObject) {
				is.name = "Rogue Block at ";
			} else if(po instanceof GoalScreenObject) {
				is.name = "Goal at ";
			} else if(po instanceof DoorSourceScreenObject) {
				is.name = "Door Source at ";
			} else if(po instanceof DoorDestinationScreenObject) {
				is.name = "Door Destination at ";
			} else if(po instanceof ConveyorScreenObject) {
				is.name = "Conveyor at ";
			} else if(po instanceof LevelStartScreenObject) {
				is.name = "Level Starting-Point at ";
			} else if(po instanceof HurtzoneScreenObject) {
				is.name = "Hurtzone at ";
			} else {
				is.name = "Screen Object at ";
			}
			
			is.name = is.name + po.getClickRect().getCenter().x + ", " + po.getClickRect().getCenter().y;
			
			innerList.add(is);
			
			
		}
		
		list = new JList(innerList);
		list.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
		JScrollPane scrollPane = new JScrollPane(list);
		
		
		
		JPanel lowerButtonsPanel = new JPanel();
		lowerButtonsPanel.setLayout(new GridLayout(1, 3));
		
		JButton cancelButton = new JButton("Cancel");
		cancelButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				cancelWasClicked();
			}
		});
		lowerButtonsPanel.add(cancelButton);
		
		
		JButton allButton = new JButton("Delete All");
		allButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				allWasClicked();
			}
		});
		lowerButtonsPanel.add(allButton);
		
		
		JButton okButton = new JButton("OK");
		okButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				okWasClicked();
			}
		});
		lowerButtonsPanel.add(okButton);
		
		
		this.setLayout(new BorderLayout());
		this.add(scrollPane, BorderLayout.CENTER);
		this.add(lowerButtonsPanel, BorderLayout.SOUTH);
		
		
		
		
	}
	
	private void okWasClicked() {
		
		int selectedIndexes[] = list.getSelectedIndices();
		
		ArrayList<Integer> indexesToBeErasedRaw = new ArrayList<Integer>();
		
		for(int ind : selectedIndexes) {
			indexesToBeErasedRaw.add(innerList.get(ind).origItemIndex);
		}
		
		indexesToBeErased = new int[indexesToBeErasedRaw.size()];
		for(int i = 0; i < indexesToBeErasedRaw.size(); i++) {
			indexesToBeErased[i] = indexesToBeErasedRaw.get(i);
		}
		
		parent.setVisible(false);
		
	}
	
	private void cancelWasClicked() {
		indexesToBeErased = new int[0];
		parent.setVisible(false);
		
	}
	
	private void allWasClicked() {
		
		indexesToBeErased = new int[innerList.size()];
		for(int i = 0; i < innerList.size(); i++) {
			indexesToBeErased[i] = innerList.get(i).origItemIndex;
		}
		

		parent.setVisible(false);
		
	}
	
	
	public static int[] selectDeletableObjects(ArrayList<Integer> indexesForErasure, ArrayList<ScreenObject> objectsForErasure) {
		JDialog dialog = new JDialog();
		dialog.setModal(true);
		dialog.setTitle("Select object(s) to delete");
		
		DeleteSelectionWizard panel = new DeleteSelectionWizard(indexesForErasure, objectsForErasure, dialog);
		
		dialog.setMaximumSize(new Dimension(300, 250));
		dialog.setMinimumSize(new Dimension(300, 250));
		dialog.setPreferredSize(new Dimension(300, 250));
		dialog.setContentPane(panel);
		
		dialog.setVisible(true);
		
		int indexes[] = panel.getIndexesToBeErased();
		
		dialog.dispose();
		
		return indexes;
		
	}
	
	
	
	/*public static void main(String [] args) {
		
		
		
		ArrayList<Integer> indexesForErasure = new ArrayList<Integer>();
		indexesForErasure.add(0);
		indexesForErasure.add(1);
		indexesForErasure.add(20);
		indexesForErasure.add(33);
		indexesForErasure.add(400);
		indexesForErasure.add(555);
		
		ArrayList<ScreenObject> objectsForErasure = new ArrayList<ScreenObject>();
		objectsForErasure.add(new ScreenObject() {
			
			@Override
			public IntRect getClickRect() {
				// TODO Auto-generated method stub
				return new IntRect(20, 20, 20, 20);
			}
			
			@Override
			public void draw(Graphics g) {}
		});
		objectsForErasure.add(new HeartScreenObject(40, 40, null));
		objectsForErasure.add(new HeartScreenObject(60, 20, null));
		objectsForErasure.add(new ScreenObject() {
			
			@Override
			public IntRect getClickRect() {
				// TODO Auto-generated method stub
				return new IntRect(10, 10, 1, 1);
			}
			
			@Override
			public void draw(Graphics g) { }
		});
		objectsForErasure.add(new HeartScreenObject(80, 80, null));
		objectsForErasure.add(new HeartScreenObject(10, 100, null));
		
		
		
		JDialog dialog = new JDialog();
		dialog.setModal(true);
		dialog.setTitle("Select object(s) to delete");
		
		DeleteSelectionWizard panel = new DeleteSelectionWizard(indexesForErasure, objectsForErasure, dialog);
		
		dialog.setMaximumSize(new Dimension(300, 250));
		dialog.setMinimumSize(new Dimension(300, 250));
		dialog.setPreferredSize(new Dimension(300, 250));
		dialog.setContentPane(panel);
		
		dialog.setVisible(true);
		
		int indexes[] = panel.getIndexesToBeErased();
		
		if(indexes == null)
			System.out.println("null?!");
		else
			for(int i : indexes) {
				System.out.println("a selected index: " + i);
			}
		
		
		
		dialog.dispose();
		System.out.println("done.");
	}*/
	
}
